<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="xml">
    <title>Test op processing instructions anders dan xml</title>
    <!-- 
        De context wordt de eerste node die maar 1 parent node heeft
        Mooier was de root node zelf geweest, maar dat is lastig vanuit 
        schematron.
    -->
    <rule context="*[count(ancestor::*)=0]">
        <!-- Loads the document as unparsed text -->
        <let name="unparsed" value="unparsed-text(document-uri(/))"/>
        
        <!-- First processing-instruction (if any) -->
        <let name="firstprocessinginstruction" value="substring-after(substring-before($unparsed, '?>'),'&lt;?')"/>
        
        <!-- Variable for the XML declaration -->
        <let name="declaration" value="if (starts-with($firstprocessinginstruction,'xml')) then ($firstprocessinginstruction) else ()"/>

        <!-- Validate if XML declaration is version 1.0. -->
        <assert role="error" test="not(contains($declaration,' version=')) or matches($declaration, 'version=.1\.0.')"
            >xml: het XML-prologattribuut moet versie 1.0 zijn.</assert>

        <!-- Validate if encoding="UTF-8" is used explicitly. -->
        <assert role="error" test="not(contains($declaration,' encoding=')) or matches($declaration, 'encoding=.(utf-8)|(UTF-8).')"
            >xml: het XML-prologattribuut encoding moet worden weggelaten of expliciet "UTF-8" zijn.</assert>

        <!-- Validate that the standalone pseudo attribute is not used. -->
        <assert role="error"
            test="/processing-instruction('nictiz') or not(contains($declaration,' standalone='))"
            >xml: het XML-prologattribuut standalone mag niet worden gebruikt.</assert>
        
        <!-- Geen processing-instruction, of slechts 1 welke de XML prolog is -->
        <assert role="error" test="count(//processing-instruction()) = 0 or /processing-instruction('nictiz')"
            >xml: de XML-prolog is de enig toegestane processing instruction. Bijvoorbeeld koppelingen naar stylesheets zijn niet toegestaan.</assert>
    </rule>
    
    <title>Test op gekoppelde XML Schema's</title>
    <rule context="*[@xsi:schemaLocation]">
        <assert role="warning" test="/processing-instruction('nictiz') or not(.)"
            >xml: er mogen geen XML Schema's zijn gekoppeld. Gevonden '<value-of select="@xsi:schemaLocation"/>'</assert>
    </rule>
    <rule context="*[@xsi:noNamespaceSchemaLocation]">
        <assert role="warning" test="/processing-instruction('nictiz') or not(.)"
            >xml: er mogen geen XML Schema's zijn gekoppeld. Gevonden '<value-of select="@xsi:noNamespaceSchemaLocation"/>'</assert>
    </rule>
    
    <title>Elementen</title>
    <!-- 2013-09-02 AH: Deze test uitgecommentarieerd omdat deze te generiek gesteld is. Lege elementen 
        kunnen in de toekomst vaker voorkomen en dan onterecht fouten geven -->
    <!-- Test op lege elementen, Place en patient als auteur van autorisatieprofielen of condities zijn uitgesloten -->
    <!--<rule context="*[not(self::hl7:Place) and 
        not(self::hl7:patient and (../../../hl7:consentDirective or ../../../hl7:IntoleranceCondition or ../../../hl7:Condition)) and
        not(*) and (not(@*) or (count(@*)=1 and @xsi:type)) and string-length(normalize-space(text()[1]))=0]">
        <assert role="error" test="not(.)"
            >xml: elementen moeten tenminste een attribuut, een onderliggend element, of tekstuele inhoud hebben</assert>
    </rule>-->
    
    <title>Attributen</title>
    <!-- Test op elementen met lege attributen -->
    <!-- AH: Merk op: als context="*" dan slaat de Schematron engine verder alle rules over. 
        Vandaar dat ik de * heb gewijzigd in onderstaande constructie waarna een rule staat 
        die gewoon altijd af moet gaan. Wellicht ziet het er vreemd uit, maar het werkt. -->
    <!--rule context="*[count(@*[string-length(normalize-space(.))=0])&gt;0]"-->
    <rule context="*[@*[normalize-space()='']]">
        <assert role="error" test="not(.)"
            >xml: attributen moeten een waarde hebben</assert>
    </rule>
</pattern>
